public class Order
{
  private readonly string cusid;
  private ArrayList items = new ArrayList();
  private int id;

  public Order(string cusid)
  {
    this.cusid = cusid;
  }

  public string CustomerId
  {
    get { return cusid; }
  }

  public int Id
  {
    get { return id; }
    set { id = value; }
  }

  public int ItemCount
  {
    get { return items.Count; }
  }

  public int QuantityOf(Product product)
  {
    foreach(Item item in items)
    {
      if(item.Product.Sku.Equals(product.Sku))
        return item.Quantity;
    }
    return 0;
  }

  public void AddItem(Product p, int qty)
  {
    Item item = new Item(p,qty);
    items.Add(item);
  }

  public ArrayList Items
  {
    get { return items; }
  }

  public int Total
  {
    get
    {
      int total = 0;
      foreach(Item item in items)
      {
        Product p = item.Product;
        int qty = item.Quantity;
        total += p.Price * qty;
      }
      return total;
    }
  }
}
